package physx.cooking;

/**
 * Mesh midphase structure. This enum is used to select the desired acceleration structure for midphase queries
 *  (i.e. raycasts, overlaps, sweeps vs triangle meshes).
 * <p>
 *  The PxMeshMidPhase::eBVH33 structure is the one used in recent PhysX versions (up to PhysX 3.3). It has great performance and is
 *  supported on all platforms. It is deprecated since PhysX 5.x.
 * <p>
 *  The PxMeshMidPhase::eBVH34 structure is a revisited implementation introduced in PhysX 3.4. It can be significantly faster both
 *  in terms of cooking performance and runtime performance.
 */
public enum PxMeshMidPhaseEnum {

    /**
     * Default midphase mesh structure, as used up to PhysX 3.3 (deprecated)
     */
    eBVH33(_geteBVH33()),
    /**
     * New midphase mesh structure, introduced in PhysX 3.4
     */
    eBVH34(_geteBVH34());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxMeshMidPhaseEnum(int value) {
        this.value = value;
    }

    private static native int _geteBVH33();
    private static native int _geteBVH34();
    public static PxMeshMidPhaseEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxMeshMidPhaseEnum: " + value);
    }

}
