package physx.cooking;

/**
 * Enum for the set of mesh pre-processing parameters.
 */
public enum PxMeshPreprocessingFlagEnum {

    /**
     * When set, mesh welding is performed. See PxCookingParams::meshWeldTolerance. Clean mesh must be enabled.
     */
    eWELD_VERTICES(_geteWELD_VERTICES()),
    /**
     * When set, mesh cleaning is disabled. This makes cooking faster.
     * <p>
     * When clean mesh is not performed, mesh welding is also not performed. 
     * <p>
     * It is recommended to use only meshes that passed during validateTriangleMesh. 
     */
    eDISABLE_CLEAN_MESH(_geteDISABLE_CLEAN_MESH()),
    /**
     * When set, active edges are set for each triangle edge. This makes cooking faster but slow up contact generation.
     */
    eDISABLE_ACTIVE_EDGES_PRECOMPUTE(_geteDISABLE_ACTIVE_EDGES_PRECOMPUTE()),
    /**
     * When set, 32-bit indices will always be created regardless of triangle count.
     * <p>
     * <b>Note:</b> By default mesh will be created with 16-bit indices for triangle count &lt;= 0xFFFF and 32-bit otherwise.
     */
    eFORCE_32BIT_INDICES(_geteFORCE_32BIT_INDICES());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxMeshPreprocessingFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteWELD_VERTICES();
    private static native int _geteDISABLE_CLEAN_MESH();
    private static native int _geteDISABLE_ACTIVE_EDGES_PRECOMPUTE();
    private static native int _geteFORCE_32BIT_INDICES();
    public static PxMeshPreprocessingFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxMeshPreprocessingFlagEnum: " + value);
    }

}
