package physx.extensions;

/**
 * flags for configuring the drive model of a PxD6Joint
 * <p>
 * <b>See also:</b> PxD6JointDrive PxD6Joint
 */
public enum PxD6JointDriveFlagEnum {

    eACCELERATION(_geteACCELERATION());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxD6JointDriveFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteACCELERATION();
    public static PxD6JointDriveFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxD6JointDriveFlagEnum: " + value);
    }

}
