package physx.extensions;

/**
 * flags for configuring the drive of a PxDistanceJoint
 * <p>
 * <b>See also:</b> PxDistanceJoint
 */
public enum PxDistanceJointFlagEnum {

    eMAX_DISTANCE_ENABLED(_geteMAX_DISTANCE_ENABLED()),
    eMIN_DISTANCE_ENABLED(_geteMIN_DISTANCE_ENABLED()),
    eSPRING_ENABLED(_geteSPRING_ENABLED());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxDistanceJointFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteMAX_DISTANCE_ENABLED();
    private static native int _geteMIN_DISTANCE_ENABLED();
    private static native int _geteSPRING_ENABLED();
    public static PxDistanceJointFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxDistanceJointFlagEnum: " + value);
    }

}
