package physx.extensions;

/**
 * an enumeration for specifying one or other of the actors referenced by a joint
 * <p>
 * <b>See also:</b> PxJoint
 */
public enum PxJointActorIndexEnum {

    eACTOR0(_geteACTOR0()),
    eACTOR1(_geteACTOR1());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxJointActorIndexEnum(int value) {
        this.value = value;
    }

    private static native int _geteACTOR0();
    private static native int _geteACTOR1();
    public static PxJointActorIndexEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxJointActorIndexEnum: " + value);
    }

}
