package physx.extensions;


public class PxJointAngularLimitPair extends PxJointLimitParameters {

    protected PxJointAngularLimitPair() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxJointAngularLimitPair wrapPointer(long address) {
        return address != 0L ? new PxJointAngularLimitPair(address) : null;
    }
    
    public static PxJointAngularLimitPair arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxJointAngularLimitPair(long address) {
        super(address);
    }

    // Constructors

    /**
     * construct an angular soft limit pair. 
     * <p>
     * The lower value must be less than the upper value. 
     * @param lowerLimit The lower angle of the limit
     * @param upperLimit The upper angle of the limit
     * @param spring  The stiffness and damping of the limit spring
     * @see PxJointLimitParameters
     */
    public PxJointAngularLimitPair(float lowerLimit, float upperLimit, PxSpring spring) {
        address = _PxJointAngularLimitPair(lowerLimit, upperLimit, spring.getAddress());
    }
    private static native long _PxJointAngularLimitPair(float lowerLimit, float upperLimit, long spring);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getUpper() {
        checkNotNull();
        return _getUpper(address);
    }
    private static native float _getUpper(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setUpper(float value) {
        checkNotNull();
        _setUpper(address, value);
    }
    private static native void _setUpper(long address, float value);

    /**
     * the range of the limit. The upper limit must be no lower than the lower limit.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> See the joint on which the limit is used for details<br>
     * <b>Default:</b> lower = -PI/2, upper = PI/2
     */
    public float getLower() {
        checkNotNull();
        return _getLower(address);
    }
    private static native float _getLower(long address);

    /**
     * the range of the limit. The upper limit must be no lower than the lower limit.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> See the joint on which the limit is used for details<br>
     * <b>Default:</b> lower = -PI/2, upper = PI/2
     */
    public void setLower(float value) {
        checkNotNull();
        _setLower(address, value);
    }
    private static native void _setLower(long address, float value);

}
