package physx.extensions;

/**
 * Flags specific to the Revolute Joint.
 * <p>
 * <b>See also:</b> PxRevoluteJoint
 */
public enum PxRevoluteJointFlagEnum {

    /**
     * enable the limit
     */
    eLIMIT_ENABLED(_geteLIMIT_ENABLED()),
    /**
     * enable the drive
     */
    eDRIVE_ENABLED(_geteDRIVE_ENABLED()),
    eDRIVE_FREESPIN(_geteDRIVE_FREESPIN());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxRevoluteJointFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteLIMIT_ENABLED();
    private static native int _geteDRIVE_ENABLED();
    private static native int _geteDRIVE_FREESPIN();
    public static PxRevoluteJointFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxRevoluteJointFlagEnum: " + value);
    }

}
