package physx.extensions;

/**
 * Flags specific to the spherical joint.
 * <p>
 * <b>See also:</b> PxSphericalJoint
 */
public enum PxSphericalJointFlagEnum {

    eLIMIT_ENABLED(_geteLIMIT_ENABLED());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxSphericalJointFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteLIMIT_ENABLED();
    public static PxSphericalJointFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxSphericalJointFlagEnum: " + value);
    }

}
