package physx.geometry;

/**
 * A geometry type.
 * <p>
 * Used to distinguish the type of a ::PxGeometry object.
 */
public enum PxGeometryTypeEnum {

    eSPHERE(_geteSPHERE()),
    ePLANE(_getePLANE()),
    eCAPSULE(_geteCAPSULE()),
    eBOX(_geteBOX()),
    eCONVEXMESH(_geteCONVEXMESH()),
    eTRIANGLEMESH(_geteTRIANGLEMESH()),
    eHEIGHTFIELD(_geteHEIGHTFIELD());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxGeometryTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteSPHERE();
    private static native int _getePLANE();
    private static native int _geteCAPSULE();
    private static native int _geteBOX();
    private static native int _geteCONVEXMESH();
    private static native int _geteTRIANGLEMESH();
    private static native int _geteHEIGHTFIELD();
    public static PxGeometryTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxGeometryTypeEnum: " + value);
    }

}
