package physx.geometry;

/**
 * Describes the format of height field samples.
 * <b>See also:</b> PxHeightFieldDesc.format PxHeightFieldDesc.samples
 */
public enum PxHeightFieldFormatEnum {

    /**
     * Height field height data is 16 bit signed integers, followed by triangle materials. 
     * <p>
     * Each sample is 32 bits wide arranged as follows:
     * <p>
     * \image html heightFieldFormat_S16_TM.png
     * <p>
     * 1) First there is a 16 bit height value.
     * 2) Next, two one byte material indices, with the high bit of each byte reserved for special use.
     * (so the material index is only 7 bits).
     * The high bit of material0 is the tess-flag.
     * The high bit of material1 is reserved for future use.
     * <p>
     * There are zero or more unused bytes before the next sample depending on PxHeightFieldDesc.sampleStride, 
     * where the application may eventually keep its own data.
     * <p>
     * This is the only format supported at the moment.
     * <p>
     * <b>See also:</b> PxHeightFieldDesc.format PxHeightFieldDesc.samples
     */
    eS16_TM(_geteS16_TM());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxHeightFieldFormatEnum(int value) {
        this.value = value;
    }

    private static native int _geteS16_TM();
    public static PxHeightFieldFormatEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxHeightFieldFormatEnum: " + value);
    }

}
