package physx.geometry;

/**
 * Enum with flag values to be used in PxSimpleTriangleMesh::flags.
 */
public enum PxMeshFlagEnum {

    /**
     * Specifies if the SDK should flip normals.
     * <p>
     * The PhysX libraries assume that the face normal of a triangle with vertices [a,b,c] can be computed as:
     * edge1 = b-a
     * edge2 = c-a
     * face_normal = edge1 x edge2.
     * <p>
     * Note: This is the same as a counterclockwise winding in a right handed coordinate system or
     * alternatively a clockwise winding order in a left handed coordinate system.
     * <p>
     * If this does not match the winding order for your triangles, raise the below flag.
     */
    eFLIPNORMALS(_geteFLIPNORMALS()),
    e16_BIT_INDICES(_gete16_BIT_INDICES());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxMeshFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteFLIPNORMALS();
    private static native int _gete16_BIT_INDICES();
    public static PxMeshFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxMeshFlagEnum: " + value);
    }

}
