package physx.geometry;

/**
 * Flags controlling the simulated behavior of the triangle mesh geometry.
 * <p>
 * Used in ::PxMeshGeometryFlags.
 */
public enum PxMeshGeometryFlagEnum {

    eDOUBLE_SIDED(_geteDOUBLE_SIDED());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxMeshGeometryFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteDOUBLE_SIDED();
    public static PxMeshGeometryFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxMeshGeometryFlagEnum: " + value);
    }

}
