package physx.geometry;

/**
 * Flags for the mesh geometry properties.
 * <p>
 * Used in ::PxTriangleMeshFlags.
 */
public enum PxTriangleMeshFlagEnum {

    /**
     * The triangle mesh has 16bits vertex indices.
     */
    e16_BIT_INDICES(_gete16_BIT_INDICES()),
    /**
     * The triangle mesh has adjacency information build.
     */
    eADJACENCY_INFO(_geteADJACENCY_INFO());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxTriangleMeshFlagEnum(int value) {
        this.value = value;
    }

    private static native int _gete16_BIT_INDICES();
    private static native int _geteADJACENCY_INFO();
    public static PxTriangleMeshFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxTriangleMeshFlagEnum: " + value);
    }

}
