package physx.physics;

/**
 * Flags which control the behavior of an actor.
 * <p>
 * <b>See also:</b> PxActorFlags PxActor PxActor.setActorFlag() PxActor.getActorFlags()
 */
public enum PxActorFlagEnum {

    /**
     * Enable debug renderer for this actor
     * <p>
     * <b>See also:</b> PxScene.getRenderBuffer() PxRenderBuffer PxVisualizationParameter
     */
    eVISUALIZATION(_geteVISUALIZATION()),
    /**
     * Disables scene gravity for this actor
     */
    eDISABLE_GRAVITY(_geteDISABLE_GRAVITY()),
    /**
     * Enables the sending of PxSimulationEventCallback::onWake() and PxSimulationEventCallback::onSleep() notify events
     * <p>
     * <b>See also:</b> PxSimulationEventCallback::onWake() PxSimulationEventCallback::onSleep()
     */
    eSEND_SLEEP_NOTIFIES(_geteSEND_SLEEP_NOTIFIES()),
    /**
     * Disables simulation for the actor.
     * <p>
     * <b>Note:</b> This is only supported by PxRigidStatic and PxRigidDynamic actors and can be used to reduce the memory footprint when rigid actors are
     * used for scene queries only.
     * <p>
     * <b>Note:</b> Setting this flag will remove all constraints attached to the actor from the scene.
     * <p>
     * <b>Note:</b> If this flag is set, the following calls are forbidden:
     * \li PxRigidBody: setLinearVelocity(), setAngularVelocity(), addForce(), addTorque(), clearForce(), clearTorque(), setForceAndTorque()
     * \li PxRigidDynamic: setKinematicTarget(), setWakeCounter(), wakeUp(), putToSleep()
     * <p>
     * \par <b>Sleeping:</b>
     * Raising this flag will set all velocities and the wake counter to 0, clear all forces, clear the kinematic target, put the actor
     * to sleep and wake up all touching actors from the previous frame.
     */
    eDISABLE_SIMULATION(_geteDISABLE_SIMULATION());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxActorFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteVISUALIZATION();
    private static native int _geteDISABLE_GRAVITY();
    private static native int _geteSEND_SLEEP_NOTIFIES();
    private static native int _geteDISABLE_SIMULATION();
    public static PxActorFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxActorFlagEnum: " + value);
    }

}
