package physx.physics;

/**
 * Identifies each type of actor.
 * <b>See also:</b> PxActor 
 */
public enum PxActorTypeEnum {

    /**
     * A static rigid body
     * <b>See also:</b> PxRigidStatic
     */
    eRIGID_STATIC(_geteRIGID_STATIC()),
    /**
     * A dynamic rigid body
     * <b>See also:</b> PxRigidDynamic
     */
    eRIGID_DYNAMIC(_geteRIGID_DYNAMIC()),
    /**
     * An articulation link
     * <b>See also:</b> PxArticulationLink
     */
    eARTICULATION_LINK(_geteARTICULATION_LINK()),
    /**
     * A FEM-based soft body
     * <b>See also:</b> PxSoftBody
     */
    eSOFTBODY(_geteSOFTBODY()),
    /**
     * A FEM-based cloth
     * <b>Note:</b> In development
     * <b>See also:</b> PxFEMCloth
     */
    eFEMCLOTH(_geteFEMCLOTH()),
    /**
     * A PBD ParticleSystem
     * <b>See also:</b> PxPBDParticleSystem
     */
    ePBD_PARTICLESYSTEM(_getePBD_PARTICLESYSTEM()),
    /**
     * A FLIP ParticleSystem
     * <b>Note:</b> In development
     * <b>See also:</b> PxFLIPParticleSystem
     */
    eFLIP_PARTICLESYSTEM(_geteFLIP_PARTICLESYSTEM()),
    /**
     * A MPM ParticleSystem
     * <b>Note:</b> In development
     * <b>See also:</b> PxMPMParticleSystem
     */
    eMPM_PARTICLESYSTEM(_geteMPM_PARTICLESYSTEM()),
    /**
     * A CUSTOM ParticleSystem
     * <b>Note:</b> In development
     * <b>See also:</b> PxCUSTOMParticleSystem
     */
    eCUSTOM_PARTICLESYSTEM(_geteCUSTOM_PARTICLESYSTEM()),
    /**
     * A HairSystem
     * <b>Note:</b> In development
     * <b>See also:</b> PxHairSystem
     */
    eHAIRSYSTEM(_geteHAIRSYSTEM());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxActorTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteRIGID_STATIC();
    private static native int _geteRIGID_DYNAMIC();
    private static native int _geteARTICULATION_LINK();
    private static native int _geteSOFTBODY();
    private static native int _geteFEMCLOTH();
    private static native int _getePBD_PARTICLESYSTEM();
    private static native int _geteFLIP_PARTICLESYSTEM();
    private static native int _geteMPM_PARTICLESYSTEM();
    private static native int _geteCUSTOM_PARTICLESYSTEM();
    private static native int _geteHAIRSYSTEM();
    public static PxActorTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxActorTypeEnum: " + value);
    }

}
