package physx.physics;

import physx.NativeObject;

public class PxActorTypeFlags extends NativeObject {

    protected PxActorTypeFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxActorTypeFlags wrapPointer(long address) {
        return address != 0L ? new PxActorTypeFlags(address) : null;
    }
    
    public static PxActorTypeFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxActorTypeFlags(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned short
     * @return Stack allocated object of PxActorTypeFlags
     */
    public static PxActorTypeFlags createAt(long address, short flags) {
        __placement_new_PxActorTypeFlags(address, flags);
        PxActorTypeFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned short
     * @return Stack allocated object of PxActorTypeFlags
     */
    public static <T> PxActorTypeFlags createAt(T allocator, Allocator<T> allocate, short flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxActorTypeFlags(address, flags);
        PxActorTypeFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxActorTypeFlags(long address, short flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxActorTypeFlags(short flags) {
        address = _PxActorTypeFlags(flags);
    }
    private static native long _PxActorTypeFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxActorTypeFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxActorTypeFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxActorTypeFlagEnum} [enum]
     */
    public void raise(PxActorTypeFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxActorTypeFlagEnum} [enum]
     */
    public void clear(PxActorTypeFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
