package physx.physics;

/**
 *   \addtogroup physics
 * @{ 
 */
public enum PxArticulationAxisEnum {

    /**
     * Rotational about eX
     */
    eTWIST(_geteTWIST()),
    /**
     * Rotational about eY
     */
    eSWING1(_geteSWING1()),
    /**
     * Rotational about eZ
     */
    eSWING2(_geteSWING2()),
    /**
     * Linear in eX
     */
    eX(_geteX()),
    /**
     * Linear in eY
     */
    eY(_geteY()),
    /**
     * Linear in eZ
     */
    eZ(_geteZ());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxArticulationAxisEnum(int value) {
        this.value = value;
    }

    private static native int _geteTWIST();
    private static native int _geteSWING1();
    private static native int _geteSWING2();
    private static native int _geteX();
    private static native int _geteY();
    private static native int _geteZ();
    public static PxArticulationAxisEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationAxisEnum: " + value);
    }

}
