package physx.physics;

/**
 * These flags determine what data is read or written to the internal articulation data via cache.
 * <p>
 * <b>See also:</b> PxArticulationCache PxArticulationReducedCoordinate::copyInternalStateToCache PxArticulationReducedCoordinate::applyCache
 */
public enum PxArticulationCacheFlagEnum {

    /**
     * The joint velocities, see PxArticulationCache::jointVelocity.
     */
    eVELOCITY(_geteVELOCITY()),
    /**
     * The joint accelerations, see PxArticulationCache::jointAcceleration.
     */
    eACCELERATION(_geteACCELERATION()),
    /**
     * The joint positions, see PxArticulationCache::jointPosition.
     */
    ePOSITION(_getePOSITION()),
    /**
     * The joint forces, see PxArticulationCache::jointForce.
     */
    eFORCE(_geteFORCE()),
    /**
     * The link velocities, see PxArticulationCache::linkVelocity.
     */
    eLINK_VELOCITY(_geteLINK_VELOCITY()),
    /**
     * The link accelerations, see PxArticulationCache::linkAcceleration.
     */
    eLINK_ACCELERATION(_geteLINK_ACCELERATION()),
    /**
     * Root link transform, see PxArticulationCache::rootLinkData.
     */
    eROOT_TRANSFORM(_geteROOT_TRANSFORM()),
    /**
     * Root link velocities (read/write) and accelerations (read), see PxArticulationCache::rootLinkData.
     */
    eROOT_VELOCITIES(_geteROOT_VELOCITIES()),
    /**
     * The spatial sensor forces, see PxArticulationCache::sensorForces.
     */
    eSENSOR_FORCES(_geteSENSOR_FORCES()),
    /**
     * Solver constraint joint forces, see PxArticulationCache::jointSolverForces.
     */
    eJOINT_SOLVER_FORCES(_geteJOINT_SOLVER_FORCES()),
    eALL(_geteALL());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxArticulationCacheFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteVELOCITY();
    private static native int _geteACCELERATION();
    private static native int _getePOSITION();
    private static native int _geteFORCE();
    private static native int _geteLINK_VELOCITY();
    private static native int _geteLINK_ACCELERATION();
    private static native int _geteROOT_TRANSFORM();
    private static native int _geteROOT_VELOCITIES();
    private static native int _geteSENSOR_FORCES();
    private static native int _geteJOINT_SOLVER_FORCES();
    private static native int _geteALL();
    public static PxArticulationCacheFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationCacheFlagEnum: " + value);
    }

}
