package physx.physics;

public enum PxArticulationDriveTypeEnum {

    /**
     * The output of the implicit spring drive controller is a force/torque.
     */
    eFORCE(_geteFORCE()),
    /**
     * The output of the implicit spring drive controller is a joint acceleration (use this to get (spatial)-inertia-invariant behavior of the drive).
     */
    eACCELERATION(_geteACCELERATION()),
    /**
     * Sets the drive gains internally to track a target position almost kinematically (i.e. with very high drive gains).
     */
    eTARGET(_geteTARGET()),
    /**
     * Sets the drive gains internally to track a target velocity almost kinematically (i.e. with very high drive gains).
     */
    eVELOCITY(_geteVELOCITY()),
    eNONE(_geteNONE());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxArticulationDriveTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteFORCE();
    private static native int _geteACCELERATION();
    private static native int _geteTARGET();
    private static native int _geteVELOCITY();
    private static native int _geteNONE();
    public static PxArticulationDriveTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationDriveTypeEnum: " + value);
    }

}
