package physx.physics;

public enum PxArticulationFlagEnum {

    /**
     * Set articulation base to be fixed.
     */
    eFIX_BASE(_geteFIX_BASE()),
    /**
     * Limits for drive effort are forces and torques rather than impulses, see PxArticulationDrive::maxForce.
     */
    eDRIVE_LIMITS_ARE_FORCES(_geteDRIVE_LIMITS_ARE_FORCES()),
    /**
     * Disable collisions between the articulation's links (note that parent/child collisions are disabled internally in either case).
     */
    eDISABLE_SELF_COLLISION(_geteDISABLE_SELF_COLLISION()),
    eCOMPUTE_JOINT_FORCES(_geteCOMPUTE_JOINT_FORCES());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxArticulationFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteFIX_BASE();
    private static native int _geteDRIVE_LIMITS_ARE_FORCES();
    private static native int _geteDISABLE_SELF_COLLISION();
    private static native int _geteCOMPUTE_JOINT_FORCES();
    public static PxArticulationFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationFlagEnum: " + value);
    }

}
