package physx.physics;

public enum PxArticulationJointTypeEnum {

    /**
     * All joint axes, i.e. degrees of freedom (DOFs) locked
     */
    eFIX(_geteFIX()),
    /**
     * Single linear DOF, e.g. cart on a rail
     */
    ePRISMATIC(_getePRISMATIC()),
    /**
     * Single rotational DOF, e.g. an elbow joint or a rotational motor, position wrapped at 2pi radians
     */
    eREVOLUTE(_geteREVOLUTE()),
    /**
     * Ball and socket joint with two or three DOFs
     */
    eSPHERICAL(_geteSPHERICAL()),
    eUNDEFINED(_geteUNDEFINED());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxArticulationJointTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteFIX();
    private static native int _getePRISMATIC();
    private static native int _geteREVOLUTE();
    private static native int _geteSPHERICAL();
    private static native int _geteUNDEFINED();
    public static PxArticulationJointTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationJointTypeEnum: " + value);
    }

}
