package physx.physics;

/**
 * Flags to configure the forces reported by articulation link sensors.
 * <p>
 * <b>See also:</b> PxArticulationSensor::setFlag
 */
public enum PxArticulationSensorFlagEnum {

    /**
     * Raise to receive forces from forward dynamics.
     */
    eFORWARD_DYNAMICS_FORCES(_geteFORWARD_DYNAMICS_FORCES()),
    /**
     * Raise to receive forces from constraint solver.
     */
    eCONSTRAINT_SOLVER_FORCES(_geteCONSTRAINT_SOLVER_FORCES()),
    eWORLD_FRAME(_geteWORLD_FRAME());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxArticulationSensorFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteFORWARD_DYNAMICS_FORCES();
    private static native int _geteCONSTRAINT_SOLVER_FORCES();
    private static native int _geteWORLD_FRAME();
    public static PxArticulationSensorFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationSensorFlagEnum: " + value);
    }

}
