package physx.physics;

/**
 * Collection of flags providing information on contact report pairs.
 * <p>
 * <b>See also:</b> PxContactPairHeader
 */
public enum PxContactPairHeaderFlagEnum {

    /**
     * The actor with index 0 has been removed from the scene.
     */
    eREMOVED_ACTOR_0(_geteREMOVED_ACTOR_0()),
    eREMOVED_ACTOR_1(_geteREMOVED_ACTOR_1());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxContactPairHeaderFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteREMOVED_ACTOR_0();
    private static native int _geteREMOVED_ACTOR_1();
    public static PxContactPairHeaderFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxContactPairHeaderFlagEnum: " + value);
    }

}
