package physx.physics;

/**
 * Parameter to addForce() and addTorque() calls, determines the exact operation that is carried out.
 * <p>
 * <b>See also:</b> PxRigidBody.addForce() PxRigidBody.addTorque()
 */
public enum PxForceModeEnum {

    /**
     * parameter has unit of mass * length / time^2, i.e., a force
     */
    eFORCE(_geteFORCE()),
    /**
     * parameter has unit of mass * length / time, i.e., force * time
     */
    eIMPULSE(_geteIMPULSE()),
    /**
     * parameter has unit of length / time, i.e., the effect is mass independent: a velocity change.
     */
    eVELOCITY_CHANGE(_geteVELOCITY_CHANGE()),
    eACCELERATION(_geteACCELERATION());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxForceModeEnum(int value) {
        this.value = value;
    }

    private static native int _geteFORCE();
    private static native int _geteIMPULSE();
    private static native int _geteVELOCITY_CHANGE();
    private static native int _geteACCELERATION();
    public static PxForceModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxForceModeEnum: " + value);
    }

}
