package physx.physics;


/**
 * Stores results of raycast queries.
 * <p>
 * ::PxHitFlag flags can be passed to raycast function, as an optimization, to cause the SDK to only compute specified members of this
 * structure.
 * <p>
 * Some members like barycentric coordinates are currently only computed for triangle meshes and height fields, but next versions
 * might provide them in other cases. The client code should check #flags to make sure returned values are valid.
 */
public class PxGeomRaycastHit extends PxLocationHit {

    protected PxGeomRaycastHit() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxGeomRaycastHit wrapPointer(long address) {
        return address != 0L ? new PxGeomRaycastHit(address) : null;
    }
    
    public static PxGeomRaycastHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxGeomRaycastHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getU() {
        checkNotNull();
        return _getU(address);
    }
    private static native float _getU(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setU(float value) {
        checkNotNull();
        _setU(address, value);
    }
    private static native void _setU(long address, float value);

    /**
     * barycentric coordinates of hit point, for triangle mesh and height field (flag: #PxHitFlag::eUV)
     */
    public float getV() {
        checkNotNull();
        return _getV(address);
    }
    private static native float _getV(long address);

    /**
     * barycentric coordinates of hit point, for triangle mesh and height field (flag: #PxHitFlag::eUV)
     */
    public void setV(float value) {
        checkNotNull();
        _setV(address, value);
    }
    private static native void _setV(long address, float value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean hadInitialOverlap() {
        checkNotNull();
        return _hadInitialOverlap(address);
    }
    private static native boolean _hadInitialOverlap(long address);

}
