package physx.physics;

/**
 * Scene query and geometry query behavior flags.
 * <p>
 * PxHitFlags are used for 3 different purposes:
 * <p>
 * 1) To request hit fields to be filled in by scene queries (such as hit position, normal, face index or UVs).
 * 2) Once query is completed, to indicate which fields are valid (note that a query may produce more valid fields than requested).
 * 3) To specify additional options for the narrow phase and mid-phase intersection routines.
 * <p>
 * All these flags apply to both scene queries and geometry queries (PxGeometryQuery).
 * <p>
 * <b>See also:</b> PxRaycastHit PxSweepHit PxOverlapHit PxScene.raycast PxScene.sweep PxScene.overlap PxGeometryQuery PxFindFaceIndex
 */
public enum PxHitFlagEnum {

    /**
     * "position" member of #PxQueryHit is valid
     */
    ePOSITION(_getePOSITION()),
    /**
     * "normal" member of #PxQueryHit is valid
     */
    eNORMAL(_geteNORMAL()),
    /**
     * "u" and "v" barycentric coordinates of #PxQueryHit are valid. Not applicable to sweep queries.
     */
    eUV(_geteUV()),
    /**
     * Performance hint flag for sweeps when it is known upfront there's no initial overlap.
     */
    eASSUME_NO_INITIAL_OVERLAP(_geteASSUME_NO_INITIAL_OVERLAP()),
    /**
     * Report all hits for meshes rather than just the first. Not applicable to sweep queries.
     */
    eMESH_MULTIPLE(_geteMESH_MULTIPLE()),
    /**
     * @deprecated Deprecated, please use eANY_HIT instead.
     */
    @Deprecated
    eMESH_ANY(_geteMESH_ANY()),
    /**
     * Report hits with back faces of mesh triangles. Also report hits for raycast
     */
    eMESH_BOTH_SIDES(_geteMESH_BOTH_SIDES()),
    /**
     * Use more accurate but slower narrow phase sweep tests.
     */
    ePRECISE_SWEEP(_getePRECISE_SWEEP()),
    /**
     * Report the minimum translation depth, normal and contact point.
     */
    eMTD(_geteMTD()),
    /**
     * "face index" member of #PxQueryHit is valid
     */
    eFACE_INDEX(_geteFACE_INDEX()),
    eDEFAULT(_geteDEFAULT()),
    /**
     * Only this subset of flags can be modified by pre-filter. Other modifications will be discarded. 
     */
    eMODIFIABLE_FLAGS(_geteMODIFIABLE_FLAGS());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxHitFlagEnum(int value) {
        this.value = value;
    }

    private static native int _getePOSITION();
    private static native int _geteNORMAL();
    private static native int _geteUV();
    private static native int _geteASSUME_NO_INITIAL_OVERLAP();
    private static native int _geteMESH_MULTIPLE();
    private static native int _geteMESH_ANY();
    private static native int _geteMESH_BOTH_SIDES();
    private static native int _getePRECISE_SWEEP();
    private static native int _geteMTD();
    private static native int _geteFACE_INDEX();
    private static native int _geteDEFAULT();
    private static native int _geteMODIFIABLE_FLAGS();
    public static PxHitFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxHitFlagEnum: " + value);
    }

}
