package physx.physics;

public enum PxPairFilteringModeEnum {

    /**
     * Output pair from BP, potentially send to user callbacks, create regular interaction object.
     * <p>
     * Enable contact pair filtering between kinematic/static or kinematic/kinematic rigid bodies.
     * <p>
     * By default contacts between these are suppressed (see #PxFilterFlag::eSUPPRESS) and don't get reported to the filter mechanism.
     * Use this mode if these pairs should go through the filtering pipeline nonetheless.
     * <p>
     * <b>Note:</b> This mode is not mutable, and must be set in PxSceneDesc at scene creation.
     */
    eKEEP(_geteKEEP()),
    /**
     * Output pair from BP, create interaction marker. Can be later switched to regular interaction.
     */
    eSUPPRESS(_geteSUPPRESS()),
    /**
     * Don't output pair from BP. Cannot be later switched to regular interaction, needs "resetFiltering" call.
     */
    eKILL(_geteKILL()),
    /**
     * Default is eSUPPRESS for compatibility with previous PhysX versions.
     */
    eDEFAULT(_geteDEFAULT());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxPairFilteringModeEnum(int value) {
        this.value = value;
    }

    private static native int _geteKEEP();
    private static native int _geteSUPPRESS();
    private static native int _geteKILL();
    private static native int _geteDEFAULT();
    public static PxPairFilteringModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxPairFilteringModeEnum: " + value);
    }

}
