package physx.physics;

/**
 * Filtering flags for scene queries.
 * <p>
 * <b>See also:</b> PxQueryFilterData.flags
 */
public enum PxQueryFlagEnum {

    /**
     * Traverse static shapes
     */
    eSTATIC(_geteSTATIC()),
    /**
     * Traverse dynamic shapes
     */
    eDYNAMIC(_geteDYNAMIC()),
    /**
     * Run the pre-intersection-test filter (see #PxQueryFilterCallback::preFilter())
     */
    ePREFILTER(_getePREFILTER()),
    /**
     * Run the post-intersection-test filter (see #PxQueryFilterCallback::postFilter())
     */
    ePOSTFILTER(_getePOSTFILTER()),
    /**
     * Abort traversal as soon as any hit is found and return it via callback.block.
     */
    eANY_HIT(_geteANY_HIT()),
    /**
     * All hits are reported as touching. Overrides eBLOCK returned from user filters with eTOUCH.
     */
    eNO_BLOCK(_geteNO_BLOCK());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxQueryFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteSTATIC();
    private static native int _geteDYNAMIC();
    private static native int _getePREFILTER();
    private static native int _getePOSTFILTER();
    private static native int _geteANY_HIT();
    private static native int _geteNO_BLOCK();
    public static PxQueryFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxQueryFlagEnum: " + value);
    }

}
