package physx.physics;

/**
 * Collection of flags providing a mechanism to lock motion along/around a specific axis.
 * <p>
 * <b>See also:</b> PxRigidDynamic.setRigidDynamicLockFlag(), PxRigidBody.getRigidDynamicLockFlags()
 */
public enum PxRigidDynamicLockFlagEnum {

    eLOCK_LINEAR_X(_geteLOCK_LINEAR_X()),
    eLOCK_LINEAR_Y(_geteLOCK_LINEAR_Y()),
    eLOCK_LINEAR_Z(_geteLOCK_LINEAR_Z()),
    eLOCK_ANGULAR_X(_geteLOCK_ANGULAR_X()),
    eLOCK_ANGULAR_Y(_geteLOCK_ANGULAR_Y()),
    eLOCK_ANGULAR_Z(_geteLOCK_ANGULAR_Z());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxRigidDynamicLockFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteLOCK_LINEAR_X();
    private static native int _geteLOCK_LINEAR_Y();
    private static native int _geteLOCK_LINEAR_Z();
    private static native int _geteLOCK_ANGULAR_X();
    private static native int _geteLOCK_ANGULAR_Y();
    private static native int _geteLOCK_ANGULAR_Z();
    public static PxRigidDynamicLockFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxRigidDynamicLockFlagEnum: " + value);
    }

}
