package physx.physics;

/**
 * Flags which affect the behavior of PxShapes.
 * <p>
 * <b>See also:</b> PxShape PxShape.setFlag()
 */
public enum PxShapeFlagEnum {

    /**
     * The shape will partake in collision in the physical simulation.
     * <p>
     * <b>Note:</b> It is illegal to raise the eSIMULATION_SHAPE and eTRIGGER_SHAPE flags.
     * In the event that one of these flags is already raised the sdk will reject any 
     * attempt to raise the other.  To raise the eSIMULATION_SHAPE first ensure that 
     * eTRIGGER_SHAPE is already lowered.
     * <p>
     * <b>Note:</b> This flag has no effect if simulation is disabled for the corresponding actor (see #PxActorFlag::eDISABLE_SIMULATION).
     * <p>
     * <b>See also:</b> PxSimulationEventCallback.onContact() PxScene.setSimulationEventCallback() PxShape.setFlag(), PxShape.setFlags()
     */
    eSIMULATION_SHAPE(_geteSIMULATION_SHAPE()),
    /**
     * The shape will partake in scene queries (ray casts, overlap tests, sweeps, ...).
     */
    eSCENE_QUERY_SHAPE(_geteSCENE_QUERY_SHAPE()),
    /**
     * The shape is a trigger which can send reports whenever other shapes enter/leave its volume.
     * <p>
     * <b>Note:</b> Triangle meshes and heightfields can not be triggers. Shape creation will fail in these cases.
     * <p>
     * <b>Note:</b> Shapes marked as triggers do not collide with other objects. If an object should act both
     * as a trigger shape and a collision shape then create a rigid body with two shapes, one being a 
     * trigger shape and the other a collision shape.  It is illegal to raise the eTRIGGER_SHAPE and 
     * eSIMULATION_SHAPE flags on a single PxShape instance.  In the event that one of these flags is already 
     * raised the sdk will reject any attempt to raise the other.  To raise the eTRIGGER_SHAPE flag first 
     * ensure that eSIMULATION_SHAPE flag is already lowered.
     * <p>
     * <b>Note:</b> Trigger shapes will no longer send notification events for interactions with other trigger shapes.
     * <p>
     * <b>Note:</b> Shapes marked as triggers are allowed to participate in scene queries, provided the eSCENE_QUERY_SHAPE flag is set. 
     * <p>
     * <b>Note:</b> This flag has no effect if simulation is disabled for the corresponding actor (see #PxActorFlag::eDISABLE_SIMULATION).
     * <p>
     * <b>See also:</b> PxSimulationEventCallback.onTrigger() PxScene.setSimulationEventCallback() PxShape.setFlag(), PxShape.setFlags()
     */
    eTRIGGER_SHAPE(_geteTRIGGER_SHAPE()),
    /**
     * Enable debug renderer for this shape
     * <p>
     * <b>See also:</b> PxScene.getRenderBuffer() PxRenderBuffer PxVisualizationParameter
     */
    eVISUALIZATION(_geteVISUALIZATION());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxShapeFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteSIMULATION_SHAPE();
    private static native int _geteSCENE_QUERY_SHAPE();
    private static native int _geteTRIGGER_SHAPE();
    private static native int _geteVISUALIZATION();
    public static PxShapeFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxShapeFlagEnum: " + value);
    }

}
