package physx.physics;

/**
 * Collection of flags providing information on trigger report pairs.
 * <p>
 * <b>See also:</b> PxTriggerPair
 */
public enum PxTriggerPairFlagEnum {

    /**
     * The trigger shape has been removed from the actor/scene.
     */
    eREMOVED_SHAPE_TRIGGER(_geteREMOVED_SHAPE_TRIGGER()),
    /**
     * The shape causing the trigger event has been removed from the actor/scene.
     */
    eREMOVED_SHAPE_OTHER(_geteREMOVED_SHAPE_OTHER()),
    eNEXT_FREE(_geteNEXT_FREE());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxTriggerPairFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteREMOVED_SHAPE_TRIGGER();
    private static native int _geteREMOVED_SHAPE_OTHER();
    private static native int _geteNEXT_FREE();
    public static PxTriggerPairFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxTriggerPairFlagEnum: " + value);
    }

}
