package physx.support;

/**
 * types of instrumentation that PVD can do.
 */
public enum PxPvdInstrumentationFlagEnum {

    /**
     * Send debugging information to PVD.
     * <p>
     * This information is the actual object data of the rigid statics, shapes,
     * articulations, etc.  Sending this information has a noticeable impact on
     * performance and thus this flag should not be set if you want an accurate
     * performance profile.
     */
    eDEBUG(_geteDEBUG()),
    /**
     * Send profile information to PVD.
     * <p>
     * This information populates PVD's profile view.  It has (at this time) negligible
     * cost compared to Debug information and makes PVD *much* more useful so it is quite
     * highly recommended.
     * <p>
     * This flag works together with a PxCreatePhysics parameter.
     * Using it allows the SDK to send profile events to PVD.
     */
    ePROFILE(_getePROFILE()),
    /**
     * Send memory information to PVD.
     * <p>
     * The PVD sdk side hooks into the Foundation memory controller and listens to
     * allocation/deallocation events.  This has a noticable hit on the first frame,
     * however, this data is somewhat compressed and the PhysX SDK doesn't allocate much
     * once it hits a steady state.  This information also has a fairly negligible
     * impact and thus is also highly recommended.
     * <p>
     * This flag works together with a PxCreatePhysics parameter,
     * trackOutstandingAllocations.  Using both of them together allows users to have
     * an accurate view of the overall memory usage of the simulation at the cost of
     * a hashtable lookup per allocation/deallocation.  Again, PhysX makes a best effort
     * attempt not to allocate or deallocate during simulation so this hashtable lookup
     * tends to have no effect past the first frame.
     * <p>
     * Sending memory information without tracking outstanding allocations means that
     * PVD will accurate information about the state of the memory system before the
     * actual connection happened.
     */
    eMEMORY(_geteMEMORY()),
    eALL(_geteALL());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxPvdInstrumentationFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteDEBUG();
    private static native int _getePROFILE();
    private static native int _geteMEMORY();
    private static native int _geteALL();
    public static PxPvdInstrumentationFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxPvdInstrumentationFlagEnum: " + value);
    }

}
