package physx.vehicle2;

public enum PxVehicleAxesEnum {

    /**
     * The +x axis
     */
    ePosX(_getePosX()),
    /**
     * The -x axis
     */
    eNegX(_geteNegX()),
    /**
     * The +y axis
     */
    ePosY(_getePosY()),
    /**
     * The -y axis
     */
    eNegY(_geteNegY()),
    /**
     * The +z axis
     */
    ePosZ(_getePosZ()),
    /**
     * The -z axis
     */
    eNegZ(_geteNegZ());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxVehicleAxesEnum(int value) {
        this.value = value;
    }

    private static native int _getePosX();
    private static native int _geteNegX();
    private static native int _getePosY();
    private static native int _geteNegY();
    private static native int _getePosZ();
    private static native int _geteNegZ();
    public static PxVehicleAxesEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehicleAxesEnum: " + value);
    }

}
