package physx.vehicle2;

/**
 * Choose between a potentially more expensive but more accurate solution to the clutch model or a potentially cheaper but less accurate solution.
 * <b>See also:</b> PxVehicleClutchParams
 */
public enum PxVehicleClutchAccuracyModeEnum {

    eESTIMATE(_geteESTIMATE()),
    eBEST_POSSIBLE(_geteBEST_POSSIBLE());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxVehicleClutchAccuracyModeEnum(int value) {
        this.value = value;
    }

    private static native int _geteESTIMATE();
    private static native int _geteBEST_POSSIBLE();
    public static PxVehicleClutchAccuracyModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehicleClutchAccuracyModeEnum: " + value);
    }

}
