package physx.vehicle2;

/**
 * <b>Note:</b> Brake, drive and steer response typically reduce at increased longitudinal speed. Moreover, response to a brake, throttle or steer command is typically
 * nonlinear and may be subject to dead zones where response is constant with either zero or non-zero response. PxVehicleCommandNonLinearResponseParams allows
 * command responses to be authored as multi-variate piecewise polynomials with normalized command response a function of command value and longitudinal speed.
 */
public enum PxVehicleCommandNonLinearResponseParamsEnum {

    eMAX_NB_COMMAND_VALUES(_geteMAX_NB_COMMAND_VALUES());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxVehicleCommandNonLinearResponseParamsEnum(int value) {
        this.value = value;
    }

    private static native int _geteMAX_NB_COMMAND_VALUES();
    public static PxVehicleCommandNonLinearResponseParamsEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehicleCommandNonLinearResponseParamsEnum: " + value);
    }

}
