package physx.vehicle2;

/**
 * Each command value may be associated with a table specifying a normalized response as a function of longitudinal speed.
 * Multiple instances of PxVehicleCommandValueResponseTable allow a normalized response to be authored as a multi-variate 
 * piecewise polynomial with normalized command response expressed as a nonlinear function of command value and speed.
 */
public enum PxVehicleCommandValueResponseTableEnum {

    eMAX_NB_SPEED_RESPONSES(_geteMAX_NB_SPEED_RESPONSES());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxVehicleCommandValueResponseTableEnum(int value) {
        this.value = value;
    }

    private static native int _geteMAX_NB_SPEED_RESPONSES();
    public static PxVehicleCommandValueResponseTableEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehicleCommandValueResponseTableEnum: " + value);
    }

}
