package physx.vehicle2;

/**
 * A description of the state of transmission-related commands that are applied to a vehicle with engine drive.
 */
public enum PxVehicleEngineDriveTransmissionCommandStateEnum {

    /**
     * Special gear value to denote the automatic shift mode (often referred to as DRIVE).
     * <p>
     * When using automatic transmission, setting this value as target gear will enable automatic 
     * gear shifts between first and highest gear. If the current gear is a reverse gear or
     * the neutral gear, then this value will trigger a shift to first gear. If this value is
     * used even though there is no automatic transmission available, the gear state will remain
     * unchanged.
     */
    eAUTOMATIC_GEAR(_geteAUTOMATIC_GEAR());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxVehicleEngineDriveTransmissionCommandStateEnum(int value) {
        this.value = value;
    }

    private static native int _geteAUTOMATIC_GEAR();
    public static PxVehicleEngineDriveTransmissionCommandStateEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehicleEngineDriveTransmissionCommandStateEnum: " + value);
    }

}
