package physx.vehicle2;

/**
 * A description of the number of PxConstraintConnector instances per vehicle required to maintain suspension limit
 * and sticky tire instances.
 */
public enum PxVehiclePhysXConstraintLimitsEnum {

    eNB_DOFS_PER_PXCONSTRAINT(_geteNB_DOFS_PER_PXCONSTRAINT()),
    eNB_DOFS_PER_WHEEL(_geteNB_DOFS_PER_WHEEL()),
    eNB_WHEELS_PER_PXCONSTRAINT(_geteNB_WHEELS_PER_PXCONSTRAINT()),
    eNB_CONSTRAINTS_PER_VEHICLE(_geteNB_CONSTRAINTS_PER_VEHICLE());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxVehiclePhysXConstraintLimitsEnum(int value) {
        this.value = value;
    }

    private static native int _geteNB_DOFS_PER_PXCONSTRAINT();
    private static native int _geteNB_DOFS_PER_WHEEL();
    private static native int _geteNB_WHEELS_PER_PXCONSTRAINT();
    private static native int _geteNB_CONSTRAINTS_PER_VEHICLE();
    public static PxVehiclePhysXConstraintLimitsEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehiclePhysXConstraintLimitsEnum: " + value);
    }

}
