package physx.vehicle2;

/**
 * PhysX scene queries may be raycasts or sweeps.
 * <b>Note:</b> eNONE will result in no PhysX scene query. This option will not overwrite the associated PxVehicleRoadGeometryState.
 */
public enum PxVehiclePhysXRoadGeometryQueryTypeEnum {

    /**
     * Info about the road geometry below the wheel is provided by the user
     */
    eNONE(_geteNONE()),
    /**
     * The road geometry below the wheel is analyzed using a raycast query
     */
    eRAYCAST(_geteRAYCAST()),
    /**
     * The road geometry below the wheel is analyzed using a sweep query
     */
    eSWEEP(_geteSWEEP());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxVehiclePhysXRoadGeometryQueryTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteNONE();
    private static native int _geteRAYCAST();
    private static native int _geteSWEEP();
    public static PxVehiclePhysXRoadGeometryQueryTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehiclePhysXRoadGeometryQueryTypeEnum: " + value);
    }

}
