package physx.vehicle2;

public enum PxVehicleSuspensionJounceCalculationTypeEnum {

    /**
     * The jounce is calculated using a raycast against the plane of the road geometry state
     */
    eRAYCAST(_geteRAYCAST()),
    /**
     * The jounce is calculated by sweeping a cylinder against the plane of the road geometry state
     */
    eSWEEP(_geteSWEEP());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxVehicleSuspensionJounceCalculationTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteRAYCAST();
    private static native int _geteSWEEP();
    public static PxVehicleSuspensionJounceCalculationTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehicleSuspensionJounceCalculationTypeEnum: " + value);
    }

}
