package physx.character;


/**
 * A capsule obstacle.
 * @see PxBoxObstacle
 * @see PxObstacle
 * @see PxObstacleContext
 */
public class PxCapsuleObstacle extends PxObstacle {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCapsuleObstacle wrapPointer(long address) {
        return address != 0L ? new PxCapsuleObstacle(address) : null;
    }
    
    public static PxCapsuleObstacle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCapsuleObstacle(long address) {
        super(address);
    }

    // Constructors

    public PxCapsuleObstacle() {
        address = _PxCapsuleObstacle();
    }
    private static native long _PxCapsuleObstacle();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public float getMHalfHeight() {
        checkNotNull();
        return _getMHalfHeight(address);
    }
    private static native float _getMHalfHeight(long address);

    /**
     */
    public void setMHalfHeight(float value) {
        checkNotNull();
        _setMHalfHeight(address, value);
    }
    private static native void _setMHalfHeight(long address, float value);

    /**
     */
    public float getMRadius() {
        checkNotNull();
        return _getMRadius(address);
    }
    private static native float _getMRadius(long address);

    /**
     */
    public void setMRadius(float value) {
        checkNotNull();
        _setMRadius(address, value);
    }
    private static native void _setMRadius(long address, float value);

}
