package physx.character;

import physx.NativeObject;

/**
 * Describes a controller's internal statistics.
 */
public class PxControllerStats extends NativeObject {

    protected PxControllerStats() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerStats wrapPointer(long address) {
        return address != 0L ? new PxControllerStats(address) : null;
    }
    
    public static PxControllerStats arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerStats(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public short getNbIterations() {
        checkNotNull();
        return _getNbIterations(address);
    }
    private static native short _getNbIterations(long address);

    /**
     */
    public void setNbIterations(short value) {
        checkNotNull();
        _setNbIterations(address, value);
    }
    private static native void _setNbIterations(long address, short value);

    /**
     */
    public short getNbFullUpdates() {
        checkNotNull();
        return _getNbFullUpdates(address);
    }
    private static native short _getNbFullUpdates(long address);

    /**
     */
    public void setNbFullUpdates(short value) {
        checkNotNull();
        _setNbFullUpdates(address, value);
    }
    private static native void _setNbFullUpdates(long address, short value);

    /**
     */
    public short getNbPartialUpdates() {
        checkNotNull();
        return _getNbPartialUpdates(address);
    }
    private static native short _getNbPartialUpdates(long address);

    /**
     */
    public void setNbPartialUpdates(short value) {
        checkNotNull();
        _setNbPartialUpdates(address, value);
    }
    private static native void _setNbPartialUpdates(long address, short value);

    /**
     */
    public short getNbTessellation() {
        checkNotNull();
        return _getNbTessellation(address);
    }
    private static native short _getNbTessellation(long address);

    /**
     */
    public void setNbTessellation(short value) {
        checkNotNull();
        _setNbTessellation(address, value);
    }
    private static native void _setNbTessellation(long address, short value);

}
