package physx.character;

import physx.NativeObject;
import physx.common.PxQuat;
import physx.geometry.PxGeometryTypeEnum;

/**
 * Base class for obstacles.
 * @see PxBoxObstacle
 * @see PxCapsuleObstacle
 * @see PxObstacleContext
 */
public class PxObstacle extends NativeObject {

    protected PxObstacle() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxObstacle wrapPointer(long address) {
        return address != 0L ? new PxObstacle(address) : null;
    }
    
    public static PxObstacle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxObstacle(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public NativeObject getMUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getMUserData(address));
    }
    private static native long _getMUserData(long address);

    /**
     */
    public void setMUserData(NativeObject value) {
        checkNotNull();
        _setMUserData(address, value.getAddress());
    }
    private static native void _setMUserData(long address, long value);

    /**
     */
    public PxExtendedVec3 getMPos() {
        checkNotNull();
        return PxExtendedVec3.wrapPointer(_getMPos(address));
    }
    private static native long _getMPos(long address);

    /**
     */
    public void setMPos(PxExtendedVec3 value) {
        checkNotNull();
        _setMPos(address, value.getAddress());
    }
    private static native void _setMPos(long address, long value);

    /**
     */
    public PxQuat getMRot() {
        checkNotNull();
        return PxQuat.wrapPointer(_getMRot(address));
    }
    private static native long _getMRot(long address);

    /**
     */
    public void setMRot(PxQuat value) {
        checkNotNull();
        _setMRot(address, value.getAddress());
    }
    private static native void _setMRot(long address, long value);

    // Functions

    /**
     * @return WebIDL type: {@link PxGeometryTypeEnum} [enum]
     */
    public PxGeometryTypeEnum getType() {
        checkNotNull();
        return PxGeometryTypeEnum.forValue(_getType(address));
    }
    private static native int _getType(long address);

}
