package physx.common;

import physx.NativeObject;

public class PxFoundation extends NativeObject {

    protected PxFoundation() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxFoundation wrapPointer(long address) {
        return address != 0L ? new PxFoundation(address) : null;
    }
    
    public static PxFoundation arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxFoundation(long address) {
        super(address);
    }

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
