package physx.common;

import physx.NativeObject;

/**
 * Callback interface that permits TriangleMesh, Heightfield, ConvexMesh or BVH to be used
 * directly without the need to store the cooking results into a stream.
 * <p>
 * Using this is advised only if real-time cooking is required; using "offline" cooking and
 * streams is otherwise preferred.
 * <p>
 * The default PxInsertionCallback implementations must be used. The PxPhysics
 * default callback can be obtained using the PxPhysics::getPhysicsInsertionCallback().
 * The PxCooking default callback can be obtained using the PxCooking::getStandaloneInsertionCallback().
 * @see physx.cooking.PxCooking
 * @see physx.physics.PxPhysics
 */
public class PxInsertionCallback extends NativeObject {

    protected PxInsertionCallback() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxInsertionCallback wrapPointer(long address) {
        return address != 0L ? new PxInsertionCallback(address) : null;
    }
    
    public static PxInsertionCallback arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxInsertionCallback(long address) {
        super(address);
    }

}
