package physx.common;

import physx.NativeObject;

public class PxVec3 extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVec3 wrapPointer(long address) {
        return address != 0L ? new PxVec3(address) : null;
    }
    
    public static PxVec3 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVec3(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVec3
     */
    public static PxVec3 createAt(long address) {
        __placement_new_PxVec3(address);
        PxVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVec3
     */
    public static <T> PxVec3 createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVec3(address);
        PxVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVec3(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param x       WebIDL type: float
     * @param y       WebIDL type: float
     * @param z       WebIDL type: float
     * @return Stack allocated object of PxVec3
     */
    public static PxVec3 createAt(long address, float x, float y, float z) {
        __placement_new_PxVec3(address, x, y, z);
        PxVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param x         WebIDL type: float
     * @param y         WebIDL type: float
     * @param z         WebIDL type: float
     * @return Stack allocated object of PxVec3
     */
    public static <T> PxVec3 createAt(T allocator, Allocator<T> allocate, float x, float y, float z) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVec3(address, x, y, z);
        PxVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVec3(long address, float x, float y, float z);

    // Constructors

    public PxVec3() {
        address = _PxVec3();
    }
    private static native long _PxVec3();

    /**
     * @param x WebIDL type: float
     * @param y WebIDL type: float
     * @param z WebIDL type: float
     */
    public PxVec3(float x, float y, float z) {
        address = _PxVec3(x, y, z);
    }
    private static native long _PxVec3(float x, float y, float z);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getX() {
        checkNotNull();
        return _getX(address);
    }
    private static native float _getX(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setX(float value) {
        checkNotNull();
        _setX(address, value);
    }
    private static native void _setX(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getY() {
        checkNotNull();
        return _getY(address);
    }
    private static native float _getY(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setY(float value) {
        checkNotNull();
        _setY(address, value);
    }
    private static native void _setY(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getZ() {
        checkNotNull();
        return _getZ(address);
    }
    private static native float _getZ(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setZ(float value) {
        checkNotNull();
        _setZ(address, value);
    }
    private static native void _setZ(long address, float value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isZero() {
        checkNotNull();
        return _isZero(address);
    }
    private static native boolean _isZero(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isFinite() {
        checkNotNull();
        return _isFinite(address);
    }
    private static native boolean _isFinite(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isNormalized() {
        checkNotNull();
        return _isNormalized(address);
    }
    private static native boolean _isNormalized(long address);

    /**
     * @return WebIDL type: float
     */
    public float magnitudeSquared() {
        checkNotNull();
        return _magnitudeSquared(address);
    }
    private static native float _magnitudeSquared(long address);

    /**
     * @return WebIDL type: float
     */
    public float magnitude() {
        checkNotNull();
        return _magnitude(address);
    }
    private static native float _magnitude(long address);

    /**
     * @param v WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: float
     */
    public float dot(PxVec3 v) {
        checkNotNull();
        return _dot(address, v.getAddress());
    }
    private static native float _dot(long address, long v);

    /**
     * @param v WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 cross(PxVec3 v) {
        checkNotNull();
        return PxVec3.wrapPointer(_cross(address, v.getAddress()));
    }
    private static native long _cross(long address, long v);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getNormalized() {
        checkNotNull();
        return PxVec3.wrapPointer(_getNormalized(address));
    }
    private static native long _getNormalized(long address);

    /**
     * @return WebIDL type: float
     */
    public float normalize() {
        checkNotNull();
        return _normalize(address);
    }
    private static native float _normalize(long address);

    /**
     * @return WebIDL type: float
     */
    public float normalizeSafe() {
        checkNotNull();
        return _normalizeSafe(address);
    }
    private static native float _normalizeSafe(long address);

    /**
     * @return WebIDL type: float
     */
    public float normalizeFast() {
        checkNotNull();
        return _normalizeFast(address);
    }
    private static native float _normalizeFast(long address);

    /**
     * @param a WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 multiply(PxVec3 a) {
        checkNotNull();
        return PxVec3.wrapPointer(_multiply(address, a.getAddress()));
    }
    private static native long _multiply(long address, long a);

    /**
     * @param v WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 minimum(PxVec3 v) {
        checkNotNull();
        return PxVec3.wrapPointer(_minimum(address, v.getAddress()));
    }
    private static native long _minimum(long address, long v);

    /**
     * @return WebIDL type: float
     */
    public float minElement() {
        checkNotNull();
        return _minElement(address);
    }
    private static native float _minElement(long address);

    /**
     * @param v WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 maximum(PxVec3 v) {
        checkNotNull();
        return PxVec3.wrapPointer(_maximum(address, v.getAddress()));
    }
    private static native long _maximum(long address, long v);

    /**
     * @return WebIDL type: float
     */
    public float maxElement() {
        checkNotNull();
        return _maxElement(address);
    }
    private static native float _maxElement(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 abs() {
        checkNotNull();
        return PxVec3.wrapPointer(_abs(address));
    }
    private static native long _abs(long address);

}
