package physx.cooking;

import physx.NativeObject;
import physx.common.PxInsertionCallback;
import physx.geometry.PxConvexMesh;
import physx.geometry.PxHeightField;
import physx.geometry.PxHeightFieldDesc;
import physx.geometry.PxTriangleMesh;

public class PxCooking extends NativeObject {

    protected PxCooking() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCooking wrapPointer(long address) {
        return address != 0L ? new PxCooking(address) : null;
    }
    
    public static PxCooking arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCooking(long address) {
        super(address);
    }

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param desc              WebIDL type: {@link PxConvexMeshDesc} [Const, Ref]
     * @param insertionCallback WebIDL type: {@link PxInsertionCallback} [Ref]
     * @return WebIDL type: {@link PxConvexMesh}
     */
    public PxConvexMesh createConvexMesh(PxConvexMeshDesc desc, PxInsertionCallback insertionCallback) {
        checkNotNull();
        return PxConvexMesh.wrapPointer(_createConvexMesh(address, desc.getAddress(), insertionCallback.getAddress()));
    }
    private static native long _createConvexMesh(long address, long desc, long insertionCallback);

    /**
     * @param desc              WebIDL type: {@link PxTriangleMeshDesc} [Const, Ref]
     * @param insertionCallback WebIDL type: {@link PxInsertionCallback} [Ref]
     * @return WebIDL type: {@link PxTriangleMesh}
     */
    public PxTriangleMesh createTriangleMesh(PxTriangleMeshDesc desc, PxInsertionCallback insertionCallback) {
        checkNotNull();
        return PxTriangleMesh.wrapPointer(_createTriangleMesh(address, desc.getAddress(), insertionCallback.getAddress()));
    }
    private static native long _createTriangleMesh(long address, long desc, long insertionCallback);

    /**
     * @param desc              WebIDL type: {@link PxHeightFieldDesc} [Const, Ref]
     * @param insertionCallback WebIDL type: {@link PxInsertionCallback} [Ref]
     * @return WebIDL type: {@link PxHeightField}
     */
    public PxHeightField createHeightField(PxHeightFieldDesc desc, PxInsertionCallback insertionCallback) {
        checkNotNull();
        return PxHeightField.wrapPointer(_createHeightField(address, desc.getAddress(), insertionCallback.getAddress()));
    }
    private static native long _createHeightField(long address, long desc, long insertionCallback);

}
