package physx.cooking;

import physx.NativeObject;

/**
 * Structure describing parameters affecting midphase mesh structure.
 * @see PxBVH34MidphaseDesc
 */
public class PxMidphaseDesc extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxMidphaseDesc wrapPointer(long address) {
        return address != 0L ? new PxMidphaseDesc(address) : null;
    }
    
    public static PxMidphaseDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxMidphaseDesc(long address) {
        super(address);
    }

    // Constructors

    public PxMidphaseDesc() {
        address = _PxMidphaseDesc();
    }
    private static native long _PxMidphaseDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBVH33MidphaseDesc} [Value]
     */
    public PxBVH33MidphaseDesc getMBVH33Desc() {
        checkNotNull();
        return PxBVH33MidphaseDesc.wrapPointer(_getMBVH33Desc(address));
    }
    private static native long _getMBVH33Desc(long address);

    /**
     * @param value WebIDL type: {@link PxBVH33MidphaseDesc} [Value]
     */
    public void setMBVH33Desc(PxBVH33MidphaseDesc value) {
        checkNotNull();
        _setMBVH33Desc(address, value.getAddress());
    }
    private static native void _setMBVH33Desc(long address, long value);

    /**
     * @return WebIDL type: {@link PxBVH34MidphaseDesc} [Value]
     */
    public PxBVH34MidphaseDesc getMBVH34Desc() {
        checkNotNull();
        return PxBVH34MidphaseDesc.wrapPointer(_getMBVH34Desc(address));
    }
    private static native long _getMBVH34Desc(long address);

    /**
     * @param value WebIDL type: {@link PxBVH34MidphaseDesc} [Value]
     */
    public void setMBVH34Desc(PxBVH34MidphaseDesc value) {
        checkNotNull();
        _setMBVH34Desc(address, value.getAddress());
    }
    private static native void _setMBVH34Desc(long address, long value);

    // Functions

    /**
     * Returns type of midphase mesh structure.
     * @return PxMeshMidPhase::Enum 
     */
    public PxMeshMidPhaseEnum getType() {
        checkNotNull();
        return PxMeshMidPhaseEnum.forValue(_getType(address));
    }
    private static native int _getType(long address);

    /**
     * Initialize the midphase mesh structure descriptor
     * @param type Midphase mesh structure descriptor
     */
    public void setToDefault(PxMeshMidPhaseEnum type) {
        checkNotNull();
        _setToDefault(address, type.value);
    }
    private static native void _setToDefault(long address, int type);

    /**
     * Returns true if the descriptor is valid.
     * @return true if the current settings are valid.
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
