package physx.geometry;

/**
 * Flags for the mesh geometry properties.
 * <p>
 * Used in ::PxTriangleMeshFlags.
 */
public enum PxTriangleMeshFlagEnum {

    /**
     * The triangle mesh has 16bits vertex indices.
     */
    e16_BIT_INDICES(gete16_BIT_INDICES()),
    /**
     * The triangle mesh has adjacency information build.
     */
    eADJACENCY_INFO(geteADJACENCY_INFO());
    public final int value;
    
    PxTriangleMeshFlagEnum(int value) {
        this.value = value;
    }

    private static native int _gete16_BIT_INDICES();
    private static int gete16_BIT_INDICES() {
        de.fabmax.physxjni.Loader.load();
        return _gete16_BIT_INDICES();
    }

    private static native int _geteADJACENCY_INFO();
    private static int geteADJACENCY_INFO() {
        de.fabmax.physxjni.Loader.load();
        return _geteADJACENCY_INFO();
    }

    public static PxTriangleMeshFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxTriangleMeshFlagEnum: " + value);
    }

}
