package physx.physics;

/**
 * These flags determine what data is read or written to the internal articulation data via cache.
 * <p>
 * <b>See also:</b> PxArticulationCache PxArticulationReducedCoordinate::copyInternalStateToCache PxArticulationReducedCoordinate::applyCache
 */
public enum PxArticulationCacheFlagEnum {

    /**
     * The joint velocities, see PxArticulationCache::jointVelocity.
     */
    eVELOCITY(geteVELOCITY()),
    /**
     * The joint accelerations, see PxArticulationCache::jointAcceleration.
     */
    eACCELERATION(geteACCELERATION()),
    /**
     * The joint positions, see PxArticulationCache::jointPosition.
     */
    ePOSITION(getePOSITION()),
    /**
     * The joint forces, see PxArticulationCache::jointForce.
     */
    eFORCE(geteFORCE()),
    /**
     * The link velocities, see PxArticulationCache::linkVelocity.
     */
    eLINK_VELOCITY(geteLINK_VELOCITY()),
    /**
     * The link accelerations, see PxArticulationCache::linkAcceleration.
     */
    eLINK_ACCELERATION(geteLINK_ACCELERATION()),
    /**
     * Root link transform, see PxArticulationCache::rootLinkData.
     */
    eROOT_TRANSFORM(geteROOT_TRANSFORM()),
    /**
     * Root link velocities (read/write) and accelerations (read), see PxArticulationCache::rootLinkData.
     */
    eROOT_VELOCITIES(geteROOT_VELOCITIES()),
    /**
     * The spatial sensor forces, see PxArticulationCache::sensorForces.
     */
    eSENSOR_FORCES(geteSENSOR_FORCES()),
    /**
     * Solver constraint joint forces, see PxArticulationCache::jointSolverForces.
     */
    eJOINT_SOLVER_FORCES(geteJOINT_SOLVER_FORCES()),
    eALL(geteALL());
    public final int value;
    
    PxArticulationCacheFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteVELOCITY();
    private static int geteVELOCITY() {
        de.fabmax.physxjni.Loader.load();
        return _geteVELOCITY();
    }

    private static native int _geteACCELERATION();
    private static int geteACCELERATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteACCELERATION();
    }

    private static native int _getePOSITION();
    private static int getePOSITION() {
        de.fabmax.physxjni.Loader.load();
        return _getePOSITION();
    }

    private static native int _geteFORCE();
    private static int geteFORCE() {
        de.fabmax.physxjni.Loader.load();
        return _geteFORCE();
    }

    private static native int _geteLINK_VELOCITY();
    private static int geteLINK_VELOCITY() {
        de.fabmax.physxjni.Loader.load();
        return _geteLINK_VELOCITY();
    }

    private static native int _geteLINK_ACCELERATION();
    private static int geteLINK_ACCELERATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteLINK_ACCELERATION();
    }

    private static native int _geteROOT_TRANSFORM();
    private static int geteROOT_TRANSFORM() {
        de.fabmax.physxjni.Loader.load();
        return _geteROOT_TRANSFORM();
    }

    private static native int _geteROOT_VELOCITIES();
    private static int geteROOT_VELOCITIES() {
        de.fabmax.physxjni.Loader.load();
        return _geteROOT_VELOCITIES();
    }

    private static native int _geteSENSOR_FORCES();
    private static int geteSENSOR_FORCES() {
        de.fabmax.physxjni.Loader.load();
        return _geteSENSOR_FORCES();
    }

    private static native int _geteJOINT_SOLVER_FORCES();
    private static int geteJOINT_SOLVER_FORCES() {
        de.fabmax.physxjni.Loader.load();
        return _geteJOINT_SOLVER_FORCES();
    }

    private static native int _geteALL();
    private static int geteALL() {
        de.fabmax.physxjni.Loader.load();
        return _geteALL();
    }

    public static PxArticulationCacheFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationCacheFlagEnum: " + value);
    }

}
